/*
* Developed by Collaborative Consulting LLC
* Date: 11/16/2014
* Ver: 4.3
* Initial Version: Jorge Cotillo
* PRE API compatible with JQuery 1.4+
*/
(function ($) {
    $.preAPI = {};
    $.fn.preAPI =
       function (options) {
           var settings = $.extend(true, {}, $.fn.preAPI.defaults, options);
           var serviceURL = '';
           if (settings.service.serviceURL.toLowerCase().indexOf("getpreval") >= 0) {
               serviceURL = settings.service.serviceURL + 'doi=' + settings.doi + '&key=' + settings.authentication.key + '&format=' + settings.display.format + '&logoType=' + settings.settings.logoType + '&mouseOverTextDisplay=' + settings.settings.mouseOver;
           }
           else {
               serviceURL = settings.service.serviceURL;
           }

           var htmlObject = $(this);
           $.ajax({
               url: serviceURL,
               type: "GET",
               success: function (data) {
                   $(htmlObject).html('');
                   $(htmlObject).append(data);
               },
               error: function (jqXHR, textStatus, errorThrown) {
                   $(htmlObject).html('');
                   if (settings.display.displayError === true) {
                       $(htmlObject).html("status: " + textStatus + " error: " + errorThrown);
                   }
                   else {
                       console.log("status: " + textStatus + " error: " + errorThrown);
                   }
               }
           });
       };
    $.fn.preAPI.defaults =
    {
        display:
        {
            format: 'link',
            displayError: false
        },
        service:
        {
            serviceURL: 'https://api.pre-val.org/pre-api/api/doi/GetPreval?'
        },
        authentication:
        {
            key: 'd369ec26-c84e-4d68-95d0-f4f7a54586f5',
            method: 'token'
        },
        settings:
        {
            logoType: 'mediumColor',
            mouseOver: true
        }
    };

	openPREPopup = function (doi) {
		//Get Token
		var token = '', issn = '';
		$.ajax({
			url: 'https://api.pre-val.org/pre-api/api/doi/GenerateToken?doi='+doi,
			type: "GET",
			async: false,
			success: function (data) {
				var tokenIssnObject = JSON.parse(data);
                token = tokenIssnObject.Token;
                issn = tokenIssnObject.Issn;            
			},
			error: function (jqXHR, textStatus, errorThrown) {
				console.log("status: " + textStatus + " error: " + errorThrown);
			}
		});

		if (token != '') {
			//Open Popup
			window.open('https://api.pre-val.org/pre-api/Views/DisplayPREWidget.html?doi=' + doi + '&issn=' + issn + '&token=' + token, '', 'scrollbars=1,resizable=0,width=940px,height=700px');
		}
	};

	getParameterByName = function (name) {
		name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
		var regex = new RegExp("[\\?&]" + name + "=([^&#]*)"),
			results = regex.exec(location.search);
		return results === null ? "" : decodeURIComponent(results[1].replace(/\+/g, " "));
	};
})(jQuery);
